// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Rendering
{
    /// <summary> The rendered langauge showing on the map images or map tiles. </summary>
    public readonly partial struct MapTileScheme : IEquatable<MapTileScheme>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MapTileScheme"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MapTileScheme(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string XyzValue = "xyz";
        private const string TmsValue = "tms";

        /// <summary> Return XYZ scheme for serving tiles. </summary>
        public static MapTileScheme Xyz { get; } = new MapTileScheme(XyzValue);
        /// <summary> Return TMS scheme for serving tiles. </summary>
        public static MapTileScheme Tms { get; } = new MapTileScheme(TmsValue);

        /// <summary> Determines if two <see cref="MapTileScheme"/> values are the same. </summary>
        public static bool operator ==(MapTileScheme left, MapTileScheme right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MapTileScheme"/> values are not the same. </summary>
        public static bool operator !=(MapTileScheme left, MapTileScheme right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="MapTileScheme"/>. </summary>
        public static implicit operator MapTileScheme(string value) => new MapTileScheme(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MapTileScheme other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MapTileScheme other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
