// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Rendering
{
    /// <summary> The MapTileSize. </summary>
    public readonly partial struct MapTileSize : IEquatable<MapTileSize>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MapTileSize"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MapTileSize(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Size256Value = "256";
        private const string Size512Value = "512";

        /// <summary> Return a 256 by 256 pixel tile. </summary>
        public static MapTileSize Size256 { get; } = new MapTileSize(Size256Value);
        /// <summary> Return a 512 by 512 pixel tile. </summary>
        public static MapTileSize Size512 { get; } = new MapTileSize(Size512Value);
        /// <summary> Determines if two <see cref="MapTileSize"/> values are the same. </summary>
        public static bool operator ==(MapTileSize left, MapTileSize right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MapTileSize"/> values are not the same. </summary>
        public static bool operator !=(MapTileSize left, MapTileSize right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MapTileSize"/>. </summary>
        public static implicit operator MapTileSize(string value) => new MapTileSize(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MapTileSize other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MapTileSize other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
