// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Rendering
{
    /// <summary> The TilesetID. </summary>
    public readonly partial struct MapTileSetId : IEquatable<MapTileSetId>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MapTileSetId"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MapTileSetId(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftBaseValue = "microsoft.base";
        private const string MicrosoftBaseLabelsValue = "microsoft.base.labels";
        private const string MicrosoftBaseHybridValue = "microsoft.base.hybrid";
        private const string MicrosoftTerraMainValue = "microsoft.terra.main";
        private const string MicrosoftBaseRoadValue = "microsoft.base.road";
        private const string MicrosoftBaseDarkgreyValue = "microsoft.base.darkgrey";
        private const string MicrosoftBaseLabelsRoadValue = "microsoft.base.labels.road";
        private const string MicrosoftBaseLabelsDarkgreyValue = "microsoft.base.labels.darkgrey";
        private const string MicrosoftBaseHybridRoadValue = "microsoft.base.hybrid.road";
        private const string MicrosoftBaseHybridDarkgreyValue = "microsoft.base.hybrid.darkgrey";
        private const string MicrosoftImageryValue = "microsoft.imagery";
        private const string MicrosoftWeatherRadarMainValue = "microsoft.weather.radar.main";
        private const string MicrosoftWeatherInfraredMainValue = "microsoft.weather.infrared.main";
        private const string MicrosoftTrafficAbsoluteValue = "microsoft.traffic.absolute";
        private const string MicrosoftTrafficAbsoluteMainValue = "microsoft.traffic.absolute.main";
        private const string MicrosoftTrafficRelativeValue = "microsoft.traffic.relative";
        private const string MicrosoftTrafficRelativeMainValue = "microsoft.traffic.relative.main";
        private const string MicrosoftTrafficRelativeDarkValue = "microsoft.traffic.relative.dark";
        private const string MicrosoftTrafficDelayValue = "microsoft.traffic.delay";
        private const string MicrosoftTrafficDelayMainValue = "microsoft.traffic.delay.main";
        private const string MicrosoftTrafficReducedMainValue = "microsoft.traffic.reduced.main";
        private const string MicrosoftTrafficIncidentValue = "microsoft.traffic.incident";

        /// <summary>
        /// A base map is a standard map that displays roads, natural and artificial features along with the labels for those features in a vector tile.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: vector (pbf).
        /// </summary>
        public static MapTileSetId MicrosoftBase { get; } = new MapTileSetId(MicrosoftBaseValue);
        /// <summary>
        /// Displays labels for roads, natural and artificial features in a vector tile.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: vector (pbf).
        /// </summary>
        public static MapTileSetId MicrosoftBaseLabels { get; } = new MapTileSetId(MicrosoftBaseLabelsValue);
        /// <summary>
        /// Displays road, boundary and label data in a vector tile.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: vector (pbf).
        /// </summary>
        public static MapTileSetId MicrosoftBaseHybrid { get; } = new MapTileSetId(MicrosoftBaseHybridValue);
        /// <summary>
        /// Shaded relief and terra layers.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 6. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftTerraMain { get; } = new MapTileSetId(MicrosoftTerraMainValue);
        /// <summary>
        /// All layers with our main style.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftBaseRoad { get; } = new MapTileSetId(MicrosoftBaseRoadValue);
        /// <summary>
        /// All layers with our dark grey style.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftBaseDarkgrey { get; } = new MapTileSetId(MicrosoftBaseDarkgreyValue);
        /// <summary>
        /// Label data in our main style.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftBaseLabelsRoad { get; } = new MapTileSetId(MicrosoftBaseLabelsRoadValue);
        /// <summary>
        /// Label data in our dark grey style.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftBaseLabelsDarkgrey { get; } = new MapTileSetId(MicrosoftBaseLabelsDarkgreyValue);
        /// <summary>
        /// Road, boundary and label data in our main style.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftBaseHybridRoad { get; } = new MapTileSetId(MicrosoftBaseHybridRoadValue);
        /// <summary>
        /// Road, boundary and label data in our dark grey style.&lt;br&gt;
        ///
        /// Supports zoom levels 0 through 22. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftBaseHybridDarkgrey { get; } = new MapTileSetId(MicrosoftBaseHybridDarkgreyValue);
        /// <summary>
        /// A combination of satellite and aerial imagery. Only available in S1 pricing SKU.&lt;br&gt;
        ///
        /// Supports zoom levels 1 through 19. Format: raster (jpeg).
        /// </summary>
        public static MapTileSetId MicrosoftImagery { get; } = new MapTileSetId(MicrosoftImageryValue);
        /// <summary>
        /// Weather radar tiles. Latest weather radar images including areas of rain, snow, ice and mixed conditions. For more information on the Azure Maps Weather service coverage, see [Azure Maps weather services coverage](/azure/azure-maps/weather-coverage).  For more information on Radar data, see [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#radar-images).
        ///
        /// Supports zoom levels 0 through 15. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftWeatherRadarMain { get; } = new MapTileSetId(MicrosoftWeatherRadarMainValue);
        /// <summary>
        /// Weather infrared tiles. Latest Infrared Satellite images shows clouds by their temperature.  For more information, see [Azure Maps weather services coverage](/azure/azure-maps/weather-coverage). For more information about the satellite data returned, see [Weather services in Azure Maps](/azure-maps/weather-services-concepts#satellite-images).
        ///
        /// Supports zoom levels 0 through 15. Format: raster (png).
        /// </summary>
        public static MapTileSetId MicrosoftWeatherInfraredMain { get; } = new MapTileSetId(MicrosoftWeatherInfraredMainValue);
        /// <summary> absolute traffic tiles in vector. </summary>
        public static MapTileSetId MicrosoftTrafficAbsolute { get; } = new MapTileSetId(MicrosoftTrafficAbsoluteValue);
        /// <summary> absolute traffic tiles in raster in our main style. </summary>
        public static MapTileSetId MicrosoftTrafficAbsoluteMain { get; } = new MapTileSetId(MicrosoftTrafficAbsoluteMainValue);
        /// <summary> relative traffic tiles in vector. </summary>
        public static MapTileSetId MicrosoftTrafficRelative { get; } = new MapTileSetId(MicrosoftTrafficRelativeValue);
        /// <summary> relative traffic tiles in raster in our main style. </summary>
        public static MapTileSetId MicrosoftTrafficRelativeMain { get; } = new MapTileSetId(MicrosoftTrafficRelativeMainValue);
        /// <summary> relative traffic tiles in raster in our dark style. </summary>
        public static MapTileSetId MicrosoftTrafficRelativeDark { get; } = new MapTileSetId(MicrosoftTrafficRelativeDarkValue);
        /// <summary> traffic tiles in vector. </summary>
        public static MapTileSetId MicrosoftTrafficDelay { get; } = new MapTileSetId(MicrosoftTrafficDelayValue);
        /// <summary> traffic tiles in raster in our main style. </summary>
        public static MapTileSetId MicrosoftTrafficDelayMain { get; } = new MapTileSetId(MicrosoftTrafficDelayMainValue);
        /// <summary> reduced traffic tiles in raster in our main style. </summary>
        public static MapTileSetId MicrosoftTrafficReducedMain { get; } = new MapTileSetId(MicrosoftTrafficReducedMainValue);
        /// <summary> incident tiles in vector. </summary>
        public static MapTileSetId MicrosoftTrafficIncident { get; } = new MapTileSetId(MicrosoftTrafficIncidentValue);
        /// <summary> Determines if two <see cref="MapTileSetId"/> values are the same. </summary>
        public static bool operator ==(MapTileSetId left, MapTileSetId right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MapTileSetId"/> values are not the same. </summary>
        public static bool operator !=(MapTileSetId left, MapTileSetId right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MapTileSetId"/>. </summary>
        public static implicit operator MapTileSetId(string value) => new MapTileSetId(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MapTileSetId other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MapTileSetId other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
