// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Rendering
{
    public partial class MapTileSet
    {
        internal static MapTileSet DeserializeMapTileSet(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string tileJson = default;
            string name = default;
            string description = default;
            string version = default;
            string attribution = default;
            string template = default;
            string legend = default;
            string scheme = default;
            IReadOnlyList<string> tiles = default;
            IReadOnlyList<string> grids = default;
            IReadOnlyList<string> data = default;
            int? minZoom = default;
            int? maxZoom = default;
            IReadOnlyList<float> bounds = default;
            IReadOnlyList<float> center = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tileJson"u8))
                {
                    tileJson = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("attribution"u8))
                {
                    attribution = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("template"u8))
                {
                    template = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("legend"u8))
                {
                    legend = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("scheme"u8))
                {
                    scheme = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    tiles = array;
                    continue;
                }
                if (property.NameEquals("grids"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    grids = array;
                    continue;
                }
                if (property.NameEquals("data"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    data = array;
                    continue;
                }
                if (property.NameEquals("minZoom"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minZoom = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxZoom"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxZoom = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("bounds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<float> array = new List<float>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetSingle());
                    }
                    bounds = array;
                    continue;
                }
                if (property.NameEquals("center"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<float> array = new List<float>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetSingle());
                    }
                    center = array;
                    continue;
                }
            }
            return new MapTileSet(
                tileJson,
                name,
                description,
                version,
                attribution,
                template,
                legend,
                scheme,
                tiles ?? new ChangeTrackingList<string>(),
                grids ?? new ChangeTrackingList<string>(),
                data ?? new ChangeTrackingList<string>(),
                minZoom,
                maxZoom,
                bounds ?? new ChangeTrackingList<float>(),
                center ?? new ChangeTrackingList<float>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MapTileSet FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMapTileSet(document.RootElement);
        }
    }
}
