// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Rendering
{
    /// <summary> The LocalizedMapView. </summary>
    internal readonly partial struct LocalizedMapView : IEquatable<LocalizedMapView>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LocalizedMapView"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LocalizedMapView(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AEValue = "AE";
        private const string ARValue = "AR";
        private const string BHValue = "BH";
        private const string INValue = "IN";
        private const string IQValue = "IQ";
        private const string JOValue = "JO";
        private const string KWValue = "KW";
        private const string LBValue = "LB";
        private const string MAValue = "MA";
        private const string OMValue = "OM";
        private const string PKValue = "PK";
        private const string PSValue = "PS";
        private const string QAValue = "QA";
        private const string SAValue = "SA";
        private const string SYValue = "SY";
        private const string YEValue = "YE";
        private const string AutoValue = "Auto";
        private const string UnifiedValue = "Unified";

        /// <summary> United Arab Emirates (Arabic View). </summary>
        public static LocalizedMapView AE { get; } = new LocalizedMapView(AEValue);
        /// <summary> Argentina (Argentinian View). </summary>
        public static LocalizedMapView AR { get; } = new LocalizedMapView(ARValue);
        /// <summary> Bahrain (Arabic View). </summary>
        public static LocalizedMapView BH { get; } = new LocalizedMapView(BHValue);
        /// <summary> India (Indian View). </summary>
        public static LocalizedMapView IN { get; } = new LocalizedMapView(INValue);
        /// <summary> Iraq (Arabic View). </summary>
        public static LocalizedMapView IQ { get; } = new LocalizedMapView(IQValue);
        /// <summary> Jordan (Arabic View). </summary>
        public static LocalizedMapView JO { get; } = new LocalizedMapView(JOValue);
        /// <summary> Kuwait (Arabic View). </summary>
        public static LocalizedMapView KW { get; } = new LocalizedMapView(KWValue);
        /// <summary> Lebanon (Arabic View). </summary>
        public static LocalizedMapView LB { get; } = new LocalizedMapView(LBValue);
        /// <summary> Morocco (Moroccan View). </summary>
        public static LocalizedMapView MA { get; } = new LocalizedMapView(MAValue);
        /// <summary> Oman (Arabic View). </summary>
        public static LocalizedMapView OM { get; } = new LocalizedMapView(OMValue);
        /// <summary> Pakistan (Pakistani View). </summary>
        public static LocalizedMapView PK { get; } = new LocalizedMapView(PKValue);
        /// <summary> Palestinian Authority (Arabic View). </summary>
        public static LocalizedMapView PS { get; } = new LocalizedMapView(PSValue);
        /// <summary> Qatar (Arabic View). </summary>
        public static LocalizedMapView QA { get; } = new LocalizedMapView(QAValue);
        /// <summary> Saudi Arabia (Arabic View). </summary>
        public static LocalizedMapView SA { get; } = new LocalizedMapView(SAValue);
        /// <summary> Syria (Arabic View). </summary>
        public static LocalizedMapView SY { get; } = new LocalizedMapView(SYValue);
        /// <summary> Yemen (Arabic View). </summary>
        public static LocalizedMapView YE { get; } = new LocalizedMapView(YEValue);
        /// <summary> Return the map data based on the IP address of the request. </summary>
        public static LocalizedMapView Auto { get; } = new LocalizedMapView(AutoValue);
        /// <summary> Unified View (Others). </summary>
        public static LocalizedMapView Unified { get; } = new LocalizedMapView(UnifiedValue);
        /// <summary> Determines if two <see cref="LocalizedMapView"/> values are the same. </summary>
        public static bool operator ==(LocalizedMapView left, LocalizedMapView right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LocalizedMapView"/> values are not the same. </summary>
        public static bool operator !=(LocalizedMapView left, LocalizedMapView right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LocalizedMapView"/>. </summary>
        public static implicit operator LocalizedMapView(string value) => new LocalizedMapView(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LocalizedMapView other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LocalizedMapView other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
