// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Rendering
{
    /// <summary> The IncludeText. </summary>
    internal readonly partial struct IncludeText : IEquatable<IncludeText>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IncludeText"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IncludeText(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YesValue = "yes";
        private const string NoValue = "no";

        /// <summary> Include all textual data in response. </summary>
        public static IncludeText Yes { get; } = new IncludeText(YesValue);
        /// <summary> Exclude textual data from response. Only images and country/region names will be in response. </summary>
        public static IncludeText No { get; } = new IncludeText(NoValue);
        /// <summary> Determines if two <see cref="IncludeText"/> values are the same. </summary>
        public static bool operator ==(IncludeText left, IncludeText right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IncludeText"/> values are not the same. </summary>
        public static bool operator !=(IncludeText left, IncludeText right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IncludeText"/>. </summary>
        public static implicit operator IncludeText(string value) => new IncludeText(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IncludeText other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IncludeText other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
