// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Rendering
{
    public partial class CopyrightCaption
    {
        internal static CopyrightCaption DeserializeCopyrightCaption(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string formatVersion = default;
            string copyrightsCaption = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("formatVersion"u8))
                {
                    formatVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("copyrightsCaption"u8))
                {
                    copyrightsCaption = property.Value.GetString();
                    continue;
                }
            }
            return new CopyrightCaption(formatVersion, copyrightsCaption);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CopyrightCaption FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCopyrightCaption(document.RootElement);
        }
    }
}
