// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Net;
using System.Text.Json;

namespace Azure.Maps.Geolocation
{
    public partial class CountryRegionResult
    {
        internal static CountryRegionResult DeserializeCountryRegionResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CountryRegion countryRegion = default;
            IPAddress ipAddress = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("countryRegion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    countryRegion = Geolocation.CountryRegion.DeserializeCountryRegion(property.Value);
                    continue;
                }
                if (property.NameEquals("ipAddress"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ipAddress = IPAddress.Parse(property.Value.GetString());
                    continue;
                }
            }
            return new CountryRegionResult(countryRegion, ipAddress);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CountryRegionResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCountryRegionResult(document.RootElement);
        }
    }
}
