// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagementPartner.Models
{
    /// <summary> this is the management partner state: Active or Deleted. </summary>
    public readonly partial struct ManagementPartnerState : IEquatable<ManagementPartnerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagementPartnerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagementPartnerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string DeletedValue = "Deleted";

        /// <summary> Active. </summary>
        public static ManagementPartnerState Active { get; } = new ManagementPartnerState(ActiveValue);
        /// <summary> Deleted. </summary>
        public static ManagementPartnerState Deleted { get; } = new ManagementPartnerState(DeletedValue);
        /// <summary> Determines if two <see cref="ManagementPartnerState"/> values are the same. </summary>
        public static bool operator ==(ManagementPartnerState left, ManagementPartnerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagementPartnerState"/> values are not the same. </summary>
        public static bool operator !=(ManagementPartnerState left, ManagementPartnerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagementPartnerState"/>. </summary>
        public static implicit operator ManagementPartnerState(string value) => new ManagementPartnerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagementPartnerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagementPartnerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
