// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ManagementPartner.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableManagementPartnerArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableManagementPartnerArmClient"/> class for mocking. </summary>
        protected MockableManagementPartnerArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableManagementPartnerArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableManagementPartnerArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableManagementPartnerArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="PartnerResponseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PartnerResponseResource.CreateResourceIdentifier" /> to create a <see cref="PartnerResponseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PartnerResponseResource"/> object. </returns>
        public virtual PartnerResponseResource GetPartnerResponseResource(ResourceIdentifier id)
        {
            PartnerResponseResource.ValidateResourceId(id);
            return new PartnerResponseResource(Client, id);
        }
    }
}
