// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedServices.Models
{
    /// <summary> The multi-factor authorization provider to be used for just-in-time access requests. </summary>
    public readonly partial struct MultiFactorAuthProvider : IEquatable<MultiFactorAuthProvider>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MultiFactorAuthProvider"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MultiFactorAuthProvider(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "Azure";
        private const string NoneValue = "None";

        /// <summary> Azure. </summary>
        public static MultiFactorAuthProvider Azure { get; } = new MultiFactorAuthProvider(AzureValue);
        /// <summary> None. </summary>
        public static MultiFactorAuthProvider None { get; } = new MultiFactorAuthProvider(NoneValue);
        /// <summary> Determines if two <see cref="MultiFactorAuthProvider"/> values are the same. </summary>
        public static bool operator ==(MultiFactorAuthProvider left, MultiFactorAuthProvider right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MultiFactorAuthProvider"/> values are not the same. </summary>
        public static bool operator !=(MultiFactorAuthProvider left, MultiFactorAuthProvider right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MultiFactorAuthProvider"/>. </summary>
        public static implicit operator MultiFactorAuthProvider(string value) => new MultiFactorAuthProvider(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MultiFactorAuthProvider other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MultiFactorAuthProvider other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
