// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedServices.Models
{
    /// <summary> The properties of the registration definition associated with the registration assignment. </summary>
    public partial class ManagedServicesRegistrationAssignmentRegistrationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedServicesRegistrationAssignmentRegistrationProperties"/>. </summary>
        internal ManagedServicesRegistrationAssignmentRegistrationProperties()
        {
            Authorizations = new ChangeTrackingList<ManagedServicesAuthorization>();
            EligibleAuthorizations = new ChangeTrackingList<ManagedServicesEligibleAuthorization>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedServicesRegistrationAssignmentRegistrationProperties"/>. </summary>
        /// <param name="description"> The description of the registration definition. </param>
        /// <param name="authorizations"> The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant. </param>
        /// <param name="eligibleAuthorizations"> The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant. </param>
        /// <param name="registrationDefinitionName"> The name of the registration definition. </param>
        /// <param name="provisioningState"> The current provisioning state of the registration definition. </param>
        /// <param name="manageeTenantId"> The identifier of the managed tenant. </param>
        /// <param name="manageeTenantName"> The name of the managed tenant. </param>
        /// <param name="managedByTenantId"> The identifier of the managedBy tenant. </param>
        /// <param name="managedByTenantName"> The name of the managedBy tenant. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedServicesRegistrationAssignmentRegistrationProperties(string description, IReadOnlyList<ManagedServicesAuthorization> authorizations, IReadOnlyList<ManagedServicesEligibleAuthorization> eligibleAuthorizations, string registrationDefinitionName, ManagedServicesProvisioningState? provisioningState, Guid? manageeTenantId, string manageeTenantName, Guid? managedByTenantId, string managedByTenantName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            Authorizations = authorizations;
            EligibleAuthorizations = eligibleAuthorizations;
            RegistrationDefinitionName = registrationDefinitionName;
            ProvisioningState = provisioningState;
            ManageeTenantId = manageeTenantId;
            ManageeTenantName = manageeTenantName;
            ManagedByTenantId = managedByTenantId;
            ManagedByTenantName = managedByTenantName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The description of the registration definition. </summary>
        public string Description { get; }
        /// <summary> The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant. </summary>
        public IReadOnlyList<ManagedServicesAuthorization> Authorizations { get; }
        /// <summary> The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant. </summary>
        public IReadOnlyList<ManagedServicesEligibleAuthorization> EligibleAuthorizations { get; }
        /// <summary> The name of the registration definition. </summary>
        public string RegistrationDefinitionName { get; }
        /// <summary> The current provisioning state of the registration definition. </summary>
        public ManagedServicesProvisioningState? ProvisioningState { get; }
        /// <summary> The identifier of the managed tenant. </summary>
        public Guid? ManageeTenantId { get; }
        /// <summary> The name of the managed tenant. </summary>
        public string ManageeTenantName { get; }
        /// <summary> The identifier of the managedBy tenant. </summary>
        public Guid? ManagedByTenantId { get; }
        /// <summary> The name of the managedBy tenant. </summary>
        public string ManagedByTenantName { get; }
    }
}
