// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedServices
{
    internal class ManagedServicesRegistrationAssignmentOperationSource : IOperationSource<ManagedServicesRegistrationAssignmentResource>
    {
        private readonly ArmClient _client;

        internal ManagedServicesRegistrationAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedServicesRegistrationAssignmentResource IOperationSource<ManagedServicesRegistrationAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedServicesRegistrationAssignmentData.DeserializeManagedServicesRegistrationAssignmentData(document.RootElement);
            return new ManagedServicesRegistrationAssignmentResource(_client, data);
        }

        async ValueTask<ManagedServicesRegistrationAssignmentResource> IOperationSource<ManagedServicesRegistrationAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedServicesRegistrationAssignmentData.DeserializeManagedServicesRegistrationAssignmentData(document.RootElement);
            return new ManagedServicesRegistrationAssignmentResource(_client, data);
        }
    }
}
