// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ManagedServiceIdentities.Mocking
{
    /// <summary> A class to add extension methods to ArmResource. </summary>
    public partial class MockableManagedServiceIdentitiesArmResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableManagedServiceIdentitiesArmResource"/> class for mocking. </summary>
        protected MockableManagedServiceIdentitiesArmResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableManagedServiceIdentitiesArmResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableManagedServiceIdentitiesArmResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets an object representing a SystemAssignedIdentityResource along with the instance operations that can be performed on it in the ArmResource. </summary>
        /// <returns> Returns a <see cref="SystemAssignedIdentityResource"/> object. </returns>
        public virtual SystemAssignedIdentityResource GetSystemAssignedIdentity()
        {
            return new SystemAssignedIdentityResource(Client, Id.AppendProviderResource("Microsoft.ManagedIdentity", "identities", "default"));
        }
    }
}
