// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ManagedServiceIdentities.Samples
{
    public partial class Sample_FederatedIdentityCredentialResource
    {
        // FederatedIdentityCredentialCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_FederatedIdentityCredentialCreate()
        {
            // Generated from example definition: specification/msi/resource-manager/Microsoft.ManagedIdentity/stable/2023-01-31/examples/FederatedIdentityCredentialCreate.json
            // this example is just showing the usage of "FederatedIdentityCredentials_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FederatedIdentityCredentialResource created on azure
            // for more information of creating FederatedIdentityCredentialResource, please refer to the document of FederatedIdentityCredentialResource
            string subscriptionId = "c267c0e7-0a73-4789-9e17-d26aeb0904e5";
            string resourceGroupName = "rgName";
            string resourceName = "resourceName";
            string federatedIdentityCredentialResourceName = "ficResourceName";
            ResourceIdentifier federatedIdentityCredentialResourceId = FederatedIdentityCredentialResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, federatedIdentityCredentialResourceName);
            FederatedIdentityCredentialResource federatedIdentityCredential = client.GetFederatedIdentityCredentialResource(federatedIdentityCredentialResourceId);

            // invoke the operation
            FederatedIdentityCredentialData data = new FederatedIdentityCredentialData()
            {
                IssuerUri = new Uri("https://oidc.prod-aks.azure.com/TenantGUID/IssuerGUID"),
                Subject = "system:serviceaccount:ns:svcaccount",
                Audiences =
{
"api://AzureADTokenExchange"
},
            };
            ArmOperation<FederatedIdentityCredentialResource> lro = await federatedIdentityCredential.UpdateAsync(WaitUntil.Completed, data);
            FederatedIdentityCredentialResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FederatedIdentityCredentialData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // FederatedIdentityCredentialGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_FederatedIdentityCredentialGet()
        {
            // Generated from example definition: specification/msi/resource-manager/Microsoft.ManagedIdentity/stable/2023-01-31/examples/FederatedIdentityCredentialGet.json
            // this example is just showing the usage of "FederatedIdentityCredentials_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FederatedIdentityCredentialResource created on azure
            // for more information of creating FederatedIdentityCredentialResource, please refer to the document of FederatedIdentityCredentialResource
            string subscriptionId = "c267c0e7-0a73-4789-9e17-d26aeb0904e5";
            string resourceGroupName = "rgName";
            string resourceName = "resourceName";
            string federatedIdentityCredentialResourceName = "ficResourceName";
            ResourceIdentifier federatedIdentityCredentialResourceId = FederatedIdentityCredentialResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, federatedIdentityCredentialResourceName);
            FederatedIdentityCredentialResource federatedIdentityCredential = client.GetFederatedIdentityCredentialResource(federatedIdentityCredentialResourceId);

            // invoke the operation
            FederatedIdentityCredentialResource result = await federatedIdentityCredential.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FederatedIdentityCredentialData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // FederatedIdentityCredentialDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_FederatedIdentityCredentialDelete()
        {
            // Generated from example definition: specification/msi/resource-manager/Microsoft.ManagedIdentity/stable/2023-01-31/examples/FederatedIdentityCredentialDelete.json
            // this example is just showing the usage of "FederatedIdentityCredentials_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FederatedIdentityCredentialResource created on azure
            // for more information of creating FederatedIdentityCredentialResource, please refer to the document of FederatedIdentityCredentialResource
            string subscriptionId = "c267c0e7-0a73-4789-9e17-d26aeb0904e5";
            string resourceGroupName = "rgName";
            string resourceName = "resourceName";
            string federatedIdentityCredentialResourceName = "ficResourceName";
            ResourceIdentifier federatedIdentityCredentialResourceId = FederatedIdentityCredentialResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, federatedIdentityCredentialResourceName);
            FederatedIdentityCredentialResource federatedIdentityCredential = client.GetFederatedIdentityCredentialResource(federatedIdentityCredentialResourceId);

            // invoke the operation
            await federatedIdentityCredential.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
