// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    /// <summary>
    /// A class representing a collection of <see cref="NetworkFabricRoutePolicyResource"/> and their operations.
    /// Each <see cref="NetworkFabricRoutePolicyResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="NetworkFabricRoutePolicyCollection"/> instance call the GetNetworkFabricRoutePolicies method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class NetworkFabricRoutePolicyCollection : ArmCollection, IEnumerable<NetworkFabricRoutePolicyResource>, IAsyncEnumerable<NetworkFabricRoutePolicyResource>
    {
        private readonly ClientDiagnostics _networkFabricRoutePolicyRoutePoliciesClientDiagnostics;
        private readonly RoutePoliciesRestOperations _networkFabricRoutePolicyRoutePoliciesRestClient;

        /// <summary> Initializes a new instance of the <see cref="NetworkFabricRoutePolicyCollection"/> class for mocking. </summary>
        protected NetworkFabricRoutePolicyCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="NetworkFabricRoutePolicyCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal NetworkFabricRoutePolicyCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _networkFabricRoutePolicyRoutePoliciesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ManagedNetworkFabric", NetworkFabricRoutePolicyResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(NetworkFabricRoutePolicyResource.ResourceType, out string networkFabricRoutePolicyRoutePoliciesApiVersion);
            _networkFabricRoutePolicyRoutePoliciesRestClient = new RoutePoliciesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, networkFabricRoutePolicyRoutePoliciesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Implements Route Policy PUT method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<NetworkFabricRoutePolicyResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string routePolicyName, NetworkFabricRoutePolicyData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _networkFabricRoutePolicyRoutePoliciesRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, data, cancellationToken).ConfigureAwait(false);
                var operation = new ManagedNetworkFabricArmOperation<NetworkFabricRoutePolicyResource>(new NetworkFabricRoutePolicyOperationSource(Client), _networkFabricRoutePolicyRoutePoliciesClientDiagnostics, Pipeline, _networkFabricRoutePolicyRoutePoliciesRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements Route Policy PUT method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<NetworkFabricRoutePolicyResource> CreateOrUpdate(WaitUntil waitUntil, string routePolicyName, NetworkFabricRoutePolicyData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _networkFabricRoutePolicyRoutePoliciesRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, data, cancellationToken);
                var operation = new ManagedNetworkFabricArmOperation<NetworkFabricRoutePolicyResource>(new NetworkFabricRoutePolicyOperationSource(Client), _networkFabricRoutePolicyRoutePoliciesClientDiagnostics, Pipeline, _networkFabricRoutePolicyRoutePoliciesRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements Route Policy GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> is null. </exception>
        public virtual async Task<Response<NetworkFabricRoutePolicyResource>> GetAsync(string routePolicyName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.Get");
            scope.Start();
            try
            {
                var response = await _networkFabricRoutePolicyRoutePoliciesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricRoutePolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements Route Policy GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> is null. </exception>
        public virtual Response<NetworkFabricRoutePolicyResource> Get(string routePolicyName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.Get");
            scope.Start();
            try
            {
                var response = _networkFabricRoutePolicyRoutePoliciesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricRoutePolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements RoutePolicies list by resource group GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="NetworkFabricRoutePolicyResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<NetworkFabricRoutePolicyResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _networkFabricRoutePolicyRoutePoliciesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _networkFabricRoutePolicyRoutePoliciesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new NetworkFabricRoutePolicyResource(Client, NetworkFabricRoutePolicyData.DeserializeNetworkFabricRoutePolicyData(e)), _networkFabricRoutePolicyRoutePoliciesClientDiagnostics, Pipeline, "NetworkFabricRoutePolicyCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Implements RoutePolicies list by resource group GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="NetworkFabricRoutePolicyResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<NetworkFabricRoutePolicyResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _networkFabricRoutePolicyRoutePoliciesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _networkFabricRoutePolicyRoutePoliciesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new NetworkFabricRoutePolicyResource(Client, NetworkFabricRoutePolicyData.DeserializeNetworkFabricRoutePolicyData(e)), _networkFabricRoutePolicyRoutePoliciesClientDiagnostics, Pipeline, "NetworkFabricRoutePolicyCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string routePolicyName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.Exists");
            scope.Start();
            try
            {
                var response = await _networkFabricRoutePolicyRoutePoliciesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> is null. </exception>
        public virtual Response<bool> Exists(string routePolicyName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.Exists");
            scope.Start();
            try
            {
                var response = _networkFabricRoutePolicyRoutePoliciesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> is null. </exception>
        public virtual async Task<NullableResponse<NetworkFabricRoutePolicyResource>> GetIfExistsAsync(string routePolicyName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _networkFabricRoutePolicyRoutePoliciesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<NetworkFabricRoutePolicyResource>(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricRoutePolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutePolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricRoutePolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routePolicyName"> Name of the Route Policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routePolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routePolicyName"/> is null. </exception>
        public virtual NullableResponse<NetworkFabricRoutePolicyResource> GetIfExists(string routePolicyName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routePolicyName, nameof(routePolicyName));

            using var scope = _networkFabricRoutePolicyRoutePoliciesClientDiagnostics.CreateScope("NetworkFabricRoutePolicyCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _networkFabricRoutePolicyRoutePoliciesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, routePolicyName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<NetworkFabricRoutePolicyResource>(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricRoutePolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<NetworkFabricRoutePolicyResource> IEnumerable<NetworkFabricRoutePolicyResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<NetworkFabricRoutePolicyResource> IAsyncEnumerable<NetworkFabricRoutePolicyResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
