// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ManagedNetworkFabric.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    /// <summary>
    /// A class representing the NetworkFabricL3IsolationDomain data model.
    /// The L3 Isolation Domain resource definition.
    /// </summary>
    public partial class NetworkFabricL3IsolationDomainData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricL3IsolationDomainData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="networkFabricId"> ARM Resource ID of the Network Fabric. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="networkFabricId"/> is null. </exception>
        public NetworkFabricL3IsolationDomainData(AzureLocation location, ResourceIdentifier networkFabricId) : base(location)
        {
            Argument.AssertNotNull(networkFabricId, nameof(networkFabricId));

            NetworkFabricId = networkFabricId;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFabricL3IsolationDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="redistributeConnectedSubnets"> Advertise Connected Subnets. Ex: "True" | "False". </param>
        /// <param name="redistributeStaticRoutes"> Advertise Static Routes. Ex: "True" | "False". </param>
        /// <param name="aggregateRouteConfiguration"> Aggregate route configurations. </param>
        /// <param name="connectedSubnetRoutePolicy"> Connected Subnet RoutePolicy. </param>
        /// <param name="networkFabricId"> ARM Resource ID of the Network Fabric. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkFabricL3IsolationDomainData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string annotation, RedistributeConnectedSubnet? redistributeConnectedSubnets, RedistributeStaticRoute? redistributeStaticRoutes, AggregateRouteConfiguration aggregateRouteConfiguration, ConnectedSubnetRoutePolicy connectedSubnetRoutePolicy, ResourceIdentifier networkFabricId, NetworkFabricConfigurationState? configurationState, NetworkFabricProvisioningState? provisioningState, NetworkFabricAdministrativeState? administrativeState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Annotation = annotation;
            RedistributeConnectedSubnets = redistributeConnectedSubnets;
            RedistributeStaticRoutes = redistributeStaticRoutes;
            AggregateRouteConfiguration = aggregateRouteConfiguration;
            ConnectedSubnetRoutePolicy = connectedSubnetRoutePolicy;
            NetworkFabricId = networkFabricId;
            ConfigurationState = configurationState;
            ProvisioningState = provisioningState;
            AdministrativeState = administrativeState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFabricL3IsolationDomainData"/> for deserialization. </summary>
        internal NetworkFabricL3IsolationDomainData()
        {
        }

        /// <summary> Switch configuration description. </summary>
        public string Annotation { get; set; }
        /// <summary> Advertise Connected Subnets. Ex: "True" | "False". </summary>
        public RedistributeConnectedSubnet? RedistributeConnectedSubnets { get; set; }
        /// <summary> Advertise Static Routes. Ex: "True" | "False". </summary>
        public RedistributeStaticRoute? RedistributeStaticRoutes { get; set; }
        /// <summary> Aggregate route configurations. </summary>
        public AggregateRouteConfiguration AggregateRouteConfiguration { get; set; }
        /// <summary> Connected Subnet RoutePolicy. </summary>
        public ConnectedSubnetRoutePolicy ConnectedSubnetRoutePolicy { get; set; }
        /// <summary> ARM Resource ID of the Network Fabric. </summary>
        public ResourceIdentifier NetworkFabricId { get; set; }
        /// <summary> Configuration state of the resource. </summary>
        public NetworkFabricConfigurationState? ConfigurationState { get; }
        /// <summary> Provisioning state of the resource. </summary>
        public NetworkFabricProvisioningState? ProvisioningState { get; }
        /// <summary> Administrative state of the resource. </summary>
        public NetworkFabricAdministrativeState? AdministrativeState { get; }
    }
}
