// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    /// <summary>
    /// A class representing a collection of <see cref="NetworkFabricIPExtendedCommunityResource"/> and their operations.
    /// Each <see cref="NetworkFabricIPExtendedCommunityResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="NetworkFabricIPExtendedCommunityCollection"/> instance call the GetNetworkFabricIPExtendedCommunities method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class NetworkFabricIPExtendedCommunityCollection : ArmCollection, IEnumerable<NetworkFabricIPExtendedCommunityResource>, IAsyncEnumerable<NetworkFabricIPExtendedCommunityResource>
    {
        private readonly ClientDiagnostics _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics;
        private readonly IpExtendedCommunitiesRestOperations _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient;

        /// <summary> Initializes a new instance of the <see cref="NetworkFabricIPExtendedCommunityCollection"/> class for mocking. </summary>
        protected NetworkFabricIPExtendedCommunityCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="NetworkFabricIPExtendedCommunityCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal NetworkFabricIPExtendedCommunityCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ManagedNetworkFabric", NetworkFabricIPExtendedCommunityResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(NetworkFabricIPExtendedCommunityResource.ResourceType, out string networkFabricIPExtendedCommunityIPExtendedCommunitiesApiVersion);
            _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient = new IpExtendedCommunitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, networkFabricIPExtendedCommunityIPExtendedCommunitiesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Implements IP Extended Community PUT method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<NetworkFabricIPExtendedCommunityResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string ipExtendedCommunityName, NetworkFabricIPExtendedCommunityData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, data, cancellationToken).ConfigureAwait(false);
                var operation = new ManagedNetworkFabricArmOperation<NetworkFabricIPExtendedCommunityResource>(new NetworkFabricIPExtendedCommunityOperationSource(Client), _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics, Pipeline, _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements IP Extended Community PUT method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<NetworkFabricIPExtendedCommunityResource> CreateOrUpdate(WaitUntil waitUntil, string ipExtendedCommunityName, NetworkFabricIPExtendedCommunityData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, data, cancellationToken);
                var operation = new ManagedNetworkFabricArmOperation<NetworkFabricIPExtendedCommunityResource>(new NetworkFabricIPExtendedCommunityOperationSource(Client), _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics, Pipeline, _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements IP Extended Community GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> is null. </exception>
        public virtual async Task<Response<NetworkFabricIPExtendedCommunityResource>> GetAsync(string ipExtendedCommunityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.Get");
            scope.Start();
            try
            {
                var response = await _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricIPExtendedCommunityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements IP Extended Community GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> is null. </exception>
        public virtual Response<NetworkFabricIPExtendedCommunityResource> Get(string ipExtendedCommunityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.Get");
            scope.Start();
            try
            {
                var response = _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricIPExtendedCommunityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements IpExtendedCommunities list by resource group GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="NetworkFabricIPExtendedCommunityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<NetworkFabricIPExtendedCommunityResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new NetworkFabricIPExtendedCommunityResource(Client, NetworkFabricIPExtendedCommunityData.DeserializeNetworkFabricIPExtendedCommunityData(e)), _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics, Pipeline, "NetworkFabricIPExtendedCommunityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Implements IpExtendedCommunities list by resource group GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="NetworkFabricIPExtendedCommunityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<NetworkFabricIPExtendedCommunityResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new NetworkFabricIPExtendedCommunityResource(Client, NetworkFabricIPExtendedCommunityData.DeserializeNetworkFabricIPExtendedCommunityData(e)), _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics, Pipeline, "NetworkFabricIPExtendedCommunityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string ipExtendedCommunityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.Exists");
            scope.Start();
            try
            {
                var response = await _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> is null. </exception>
        public virtual Response<bool> Exists(string ipExtendedCommunityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.Exists");
            scope.Start();
            try
            {
                var response = _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> is null. </exception>
        public virtual async Task<NullableResponse<NetworkFabricIPExtendedCommunityResource>> GetIfExistsAsync(string ipExtendedCommunityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<NetworkFabricIPExtendedCommunityResource>(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricIPExtendedCommunityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IpExtendedCommunities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NetworkFabricIPExtendedCommunityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ipExtendedCommunityName"> Name of the IP Extended Community. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ipExtendedCommunityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ipExtendedCommunityName"/> is null. </exception>
        public virtual NullableResponse<NetworkFabricIPExtendedCommunityResource> GetIfExists(string ipExtendedCommunityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ipExtendedCommunityName, nameof(ipExtendedCommunityName));

            using var scope = _networkFabricIPExtendedCommunityIPExtendedCommunitiesClientDiagnostics.CreateScope("NetworkFabricIPExtendedCommunityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _networkFabricIPExtendedCommunityIPExtendedCommunitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, ipExtendedCommunityName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<NetworkFabricIPExtendedCommunityResource>(response.GetRawResponse());
                return Response.FromValue(new NetworkFabricIPExtendedCommunityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<NetworkFabricIPExtendedCommunityResource> IEnumerable<NetworkFabricIPExtendedCommunityResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<NetworkFabricIPExtendedCommunityResource> IAsyncEnumerable<NetworkFabricIPExtendedCommunityResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
