// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.ManagedNetworkFabric.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    /// <summary>
    /// A class representing the NetworkDeviceInterface data model.
    /// Defines the NetworkInterface resource.
    /// </summary>
    public partial class NetworkDeviceInterfaceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkDeviceInterfaceData"/>. </summary>
        public NetworkDeviceInterfaceData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkDeviceInterfaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="physicalIdentifier"> Physical Identifier of the network interface. </param>
        /// <param name="connectedTo"> The ARM resource id of the interface or compute server its connected to. </param>
        /// <param name="interfaceType"> The Interface Type. Example: Management/Data. </param>
        /// <param name="ipv4Address"> IPv4Address of the interface. </param>
        /// <param name="ipv6Address"> IPv6Address of the interface. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkDeviceInterfaceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string annotation, string physicalIdentifier, string connectedTo, NetworkDeviceInterfaceType? interfaceType, IPAddress ipv4Address, string ipv6Address, NetworkFabricProvisioningState? provisioningState, NetworkFabricAdministrativeState? administrativeState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Annotation = annotation;
            PhysicalIdentifier = physicalIdentifier;
            ConnectedTo = connectedTo;
            InterfaceType = interfaceType;
            IPv4Address = ipv4Address;
            IPv6Address = ipv6Address;
            ProvisioningState = provisioningState;
            AdministrativeState = administrativeState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Switch configuration description. </summary>
        public string Annotation { get; set; }
        /// <summary> Physical Identifier of the network interface. </summary>
        public string PhysicalIdentifier { get; }
        /// <summary> The ARM resource id of the interface or compute server its connected to. </summary>
        public string ConnectedTo { get; }
        /// <summary> The Interface Type. Example: Management/Data. </summary>
        public NetworkDeviceInterfaceType? InterfaceType { get; }
        /// <summary> IPv4Address of the interface. </summary>
        public IPAddress IPv4Address { get; }
        /// <summary> IPv6Address of the interface. </summary>
        public string IPv6Address { get; }
        /// <summary> Provisioning state of the resource. </summary>
        public NetworkFabricProvisioningState? ProvisioningState { get; }
        /// <summary> Administrative state of the resource. </summary>
        public NetworkFabricAdministrativeState? AdministrativeState { get; }
    }
}
