// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Network and credential configuration currently applied on terminal server. </summary>
    public partial class VpnConfigurationPatchableProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VpnConfigurationPatchableProperties"/>. </summary>
        public VpnConfigurationPatchableProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VpnConfigurationPatchableProperties"/>. </summary>
        /// <param name="networkToNetworkInterconnectId"> ARM Resource ID of the Network To Network Interconnect. </param>
        /// <param name="peeringOption"> Peering option list. </param>
        /// <param name="optionBProperties"> option B properties. </param>
        /// <param name="optionAProperties"> option A properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VpnConfigurationPatchableProperties(ResourceIdentifier networkToNetworkInterconnectId, PeeringOption? peeringOption, OptionBProperties optionBProperties, VpnConfigurationPatchableOptionAProperties optionAProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkToNetworkInterconnectId = networkToNetworkInterconnectId;
            PeeringOption = peeringOption;
            OptionBProperties = optionBProperties;
            OptionAProperties = optionAProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ARM Resource ID of the Network To Network Interconnect. </summary>
        public ResourceIdentifier NetworkToNetworkInterconnectId { get; set; }
        /// <summary> Peering option list. </summary>
        public PeeringOption? PeeringOption { get; set; }
        /// <summary> option B properties. </summary>
        public OptionBProperties OptionBProperties { get; set; }
        /// <summary> option A properties. </summary>
        public VpnConfigurationPatchableOptionAProperties OptionAProperties { get; set; }
    }
}
