// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The response of the action validate configuration. </summary>
    public partial class ValidateConfigurationResult : NetworkFabricErrorResult
    {
        /// <summary> Initializes a new instance of <see cref="ValidateConfigurationResult"/>. </summary>
        internal ValidateConfigurationResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ValidateConfigurationResult"/>. </summary>
        /// <param name="error"> The error object. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="configurationState"> Gets the configuration state. </param>
        /// <param name="uri"> URL for the details of the response. </param>
        internal ValidateConfigurationResult(ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData, NetworkFabricConfigurationState? configurationState, Uri uri) : base(error, serializedAdditionalRawData)
        {
            ConfigurationState = configurationState;
            Uri = uri;
        }

        /// <summary> Gets the configuration state. </summary>
        public NetworkFabricConfigurationState? ConfigurationState { get; }
        /// <summary> URL for the details of the response. </summary>
        public Uri Uri { get; }
    }
}
