// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Route policy action properties. </summary>
    public partial class StatementActionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StatementActionProperties"/>. </summary>
        /// <param name="actionType"> Action type. Example: Permit | Deny | Continue. </param>
        public StatementActionProperties(RoutePolicyActionType actionType)
        {
            ActionType = actionType;
        }

        /// <summary> Initializes a new instance of <see cref="StatementActionProperties"/>. </summary>
        /// <param name="localPreference"> Local Preference of the route policy. </param>
        /// <param name="actionType"> Action type. Example: Permit | Deny | Continue. </param>
        /// <param name="ipCommunityProperties"> IP Community Properties. </param>
        /// <param name="ipExtendedCommunityProperties"> IP Extended Community Properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StatementActionProperties(long? localPreference, RoutePolicyActionType actionType, ActionIPCommunityProperties ipCommunityProperties, ActionIPExtendedCommunityProperties ipExtendedCommunityProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LocalPreference = localPreference;
            ActionType = actionType;
            IPCommunityProperties = ipCommunityProperties;
            IPExtendedCommunityProperties = ipExtendedCommunityProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StatementActionProperties"/> for deserialization. </summary>
        internal StatementActionProperties()
        {
        }

        /// <summary> Local Preference of the route policy. </summary>
        public long? LocalPreference { get; set; }
        /// <summary> Action type. Example: Permit | Deny | Continue. </summary>
        public RoutePolicyActionType ActionType { get; set; }
        /// <summary> IP Community Properties. </summary>
        public ActionIPCommunityProperties IPCommunityProperties { get; set; }
        /// <summary> IP Extended Community Properties. </summary>
        public ActionIPExtendedCommunityProperties IPExtendedCommunityProperties { get; set; }
    }
}
