// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Type of the condition used. </summary>
    public readonly partial struct RoutePolicyConditionType : IEquatable<RoutePolicyConditionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoutePolicyConditionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoutePolicyConditionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OrValue = "Or";
        private const string AndValue = "And";

        /// <summary> Or. </summary>
        public static RoutePolicyConditionType Or { get; } = new RoutePolicyConditionType(OrValue);
        /// <summary> And. </summary>
        public static RoutePolicyConditionType And { get; } = new RoutePolicyConditionType(AndValue);
        /// <summary> Determines if two <see cref="RoutePolicyConditionType"/> values are the same. </summary>
        public static bool operator ==(RoutePolicyConditionType left, RoutePolicyConditionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoutePolicyConditionType"/> values are not the same. </summary>
        public static bool operator !=(RoutePolicyConditionType left, RoutePolicyConditionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoutePolicyConditionType"/>. </summary>
        public static implicit operator RoutePolicyConditionType(string value) => new RoutePolicyConditionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoutePolicyConditionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoutePolicyConditionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
