// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Action type. Example: Permit | Deny | Continue. </summary>
    public readonly partial struct RoutePolicyActionType : IEquatable<RoutePolicyActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoutePolicyActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoutePolicyActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PermitValue = "Permit";
        private const string DenyValue = "Deny";
        private const string ContinueValue = "Continue";

        /// <summary> Permit. </summary>
        public static RoutePolicyActionType Permit { get; } = new RoutePolicyActionType(PermitValue);
        /// <summary> Deny. </summary>
        public static RoutePolicyActionType Deny { get; } = new RoutePolicyActionType(DenyValue);
        /// <summary> Continue. </summary>
        public static RoutePolicyActionType Continue { get; } = new RoutePolicyActionType(ContinueValue);
        /// <summary> Determines if two <see cref="RoutePolicyActionType"/> values are the same. </summary>
        public static bool operator ==(RoutePolicyActionType left, RoutePolicyActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoutePolicyActionType"/> values are not the same. </summary>
        public static bool operator !=(RoutePolicyActionType left, RoutePolicyActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoutePolicyActionType"/>. </summary>
        public static implicit operator RoutePolicyActionType(string value) => new RoutePolicyActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoutePolicyActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoutePolicyActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
