// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Advertise Static Routes. Ex: "True" | "False". </summary>
    public readonly partial struct RedistributeStaticRoute : IEquatable<RedistributeStaticRoute>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedistributeStaticRoute"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedistributeStaticRoute(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static RedistributeStaticRoute True { get; } = new RedistributeStaticRoute(TrueValue);
        /// <summary> False. </summary>
        public static RedistributeStaticRoute False { get; } = new RedistributeStaticRoute(FalseValue);
        /// <summary> Determines if two <see cref="RedistributeStaticRoute"/> values are the same. </summary>
        public static bool operator ==(RedistributeStaticRoute left, RedistributeStaticRoute right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedistributeStaticRoute"/> values are not the same. </summary>
        public static bool operator !=(RedistributeStaticRoute left, RedistributeStaticRoute right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedistributeStaticRoute"/>. </summary>
        public static implicit operator RedistributeStaticRoute(string value) => new RedistributeStaticRoute(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedistributeStaticRoute other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedistributeStaticRoute other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
