// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Advertise Connected Subnets. Ex: "True" | "False". </summary>
    public readonly partial struct RedistributeConnectedSubnet : IEquatable<RedistributeConnectedSubnet>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedistributeConnectedSubnet"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedistributeConnectedSubnet(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static RedistributeConnectedSubnet True { get; } = new RedistributeConnectedSubnet(TrueValue);
        /// <summary> False. </summary>
        public static RedistributeConnectedSubnet False { get; } = new RedistributeConnectedSubnet(FalseValue);
        /// <summary> Determines if two <see cref="RedistributeConnectedSubnet"/> values are the same. </summary>
        public static bool operator ==(RedistributeConnectedSubnet left, RedistributeConnectedSubnet right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedistributeConnectedSubnet"/> values are not the same. </summary>
        public static bool operator !=(RedistributeConnectedSubnet left, RedistributeConnectedSubnet right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedistributeConnectedSubnet"/>. </summary>
        public static implicit operator RedistributeConnectedSubnet(string value) => new RedistributeConnectedSubnet(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedistributeConnectedSubnet other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedistributeConnectedSubnet other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
