// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Port Group properties. </summary>
    public partial class PortGroupProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PortGroupProperties"/>. </summary>
        public PortGroupProperties()
        {
            Ports = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="PortGroupProperties"/>. </summary>
        /// <param name="name"> The name of the port group. </param>
        /// <param name="ports"> List of the ports that need to be matched. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PortGroupProperties(string name, IList<string> ports, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Ports = ports;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the port group. </summary>
        public string Name { get; set; }
        /// <summary> List of the ports that need to be matched. </summary>
        public IList<string> Ports { get; }
    }
}
