// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Type of NNI used. Example: CE | NPB. </summary>
    public readonly partial struct NniType : IEquatable<NniType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NniType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NniType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CEValue = "CE";
        private const string NpbValue = "NPB";

        /// <summary> CE. </summary>
        public static NniType CE { get; } = new NniType(CEValue);
        /// <summary> NPB. </summary>
        public static NniType Npb { get; } = new NniType(NpbValue);
        /// <summary> Determines if two <see cref="NniType"/> values are the same. </summary>
        public static bool operator ==(NniType left, NniType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NniType"/> values are not the same. </summary>
        public static bool operator !=(NniType left, NniType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NniType"/>. </summary>
        public static implicit operator NniType(string value) => new NniType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NniType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NniType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
