// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The NetworkTapRule resource definition. </summary>
    public partial class NetworkTapRulePatch : NetworkRackPatch
    {
        /// <summary> Initializes a new instance of <see cref="NetworkTapRulePatch"/>. </summary>
        public NetworkTapRulePatch()
        {
            MatchConfigurations = new ChangeTrackingList<NetworkTapRuleMatchConfiguration>();
            DynamicMatchConfigurations = new ChangeTrackingList<CommonDynamicMatchConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkTapRulePatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="configurationType"> Input method to configure Network Tap Rule. </param>
        /// <param name="tapRulesUri"> Network Tap Rules file URL. </param>
        /// <param name="matchConfigurations"> List of match configurations. </param>
        /// <param name="dynamicMatchConfigurations"> List of dynamic match configurations. </param>
        internal NetworkTapRulePatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, string annotation, NetworkFabricConfigurationType? configurationType, Uri tapRulesUri, IList<NetworkTapRuleMatchConfiguration> matchConfigurations, IList<CommonDynamicMatchConfiguration> dynamicMatchConfigurations) : base(tags, serializedAdditionalRawData)
        {
            Annotation = annotation;
            ConfigurationType = configurationType;
            TapRulesUri = tapRulesUri;
            MatchConfigurations = matchConfigurations;
            DynamicMatchConfigurations = dynamicMatchConfigurations;
        }

        /// <summary> Switch configuration description. </summary>
        public string Annotation { get; set; }
        /// <summary> Input method to configure Network Tap Rule. </summary>
        public NetworkFabricConfigurationType? ConfigurationType { get; set; }
        /// <summary> Network Tap Rules file URL. </summary>
        public Uri TapRulesUri { get; set; }
        /// <summary> List of match configurations. </summary>
        public IList<NetworkTapRuleMatchConfiguration> MatchConfigurations { get; }
        /// <summary> List of dynamic match configurations. </summary>
        public IList<CommonDynamicMatchConfiguration> DynamicMatchConfigurations { get; }
    }
}
