// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    public partial class NetworkTapPatchableParametersDestinationsItem : IUtf8JsonSerializable, IJsonModel<NetworkTapPatchableParametersDestinationsItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NetworkTapPatchableParametersDestinationsItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NetworkTapPatchableParametersDestinationsItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkTapPatchableParametersDestinationsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetworkTapPatchableParametersDestinationsItem)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        NetworkTapPatchableParametersDestinationsItem IJsonModel<NetworkTapPatchableParametersDestinationsItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkTapPatchableParametersDestinationsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetworkTapPatchableParametersDestinationsItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNetworkTapPatchableParametersDestinationsItem(document.RootElement, options);
        }

        internal static NetworkTapPatchableParametersDestinationsItem DeserializeNetworkTapPatchableParametersDestinationsItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            NetworkTapDestinationType? destinationType = default;
            ResourceIdentifier destinationId = default;
            IsolationDomainProperties isolationDomainProperties = default;
            ResourceIdentifier destinationTapRuleId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("destinationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    destinationType = new NetworkTapDestinationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("destinationId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    destinationId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isolationDomainProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isolationDomainProperties = IsolationDomainProperties.DeserializeIsolationDomainProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("destinationTapRuleId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    destinationTapRuleId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NetworkTapPatchableParametersDestinationsItem(
                name,
                destinationType,
                destinationId,
                isolationDomainProperties,
                destinationTapRuleId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NetworkTapPatchableParametersDestinationsItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkTapPatchableParametersDestinationsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NetworkTapPatchableParametersDestinationsItem)} does not support writing '{options.Format}' format.");
            }
        }

        NetworkTapPatchableParametersDestinationsItem IPersistableModel<NetworkTapPatchableParametersDestinationsItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkTapPatchableParametersDestinationsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNetworkTapPatchableParametersDestinationsItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NetworkTapPatchableParametersDestinationsItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NetworkTapPatchableParametersDestinationsItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
