// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Encapsulation Type that needs to be matched. </summary>
    public readonly partial struct NetworkTapEncapsulationType : IEquatable<NetworkTapEncapsulationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkTapEncapsulationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkTapEncapsulationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string GTPv1Value = "GTPv1";

        /// <summary> None. </summary>
        public static NetworkTapEncapsulationType None { get; } = new NetworkTapEncapsulationType(NoneValue);
        /// <summary> GTPv1. </summary>
        public static NetworkTapEncapsulationType GTPv1 { get; } = new NetworkTapEncapsulationType(GTPv1Value);
        /// <summary> Determines if two <see cref="NetworkTapEncapsulationType"/> values are the same. </summary>
        public static bool operator ==(NetworkTapEncapsulationType left, NetworkTapEncapsulationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkTapEncapsulationType"/> values are not the same. </summary>
        public static bool operator !=(NetworkTapEncapsulationType left, NetworkTapEncapsulationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkTapEncapsulationType"/>. </summary>
        public static implicit operator NetworkTapEncapsulationType(string value) => new NetworkTapEncapsulationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkTapEncapsulationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkTapEncapsulationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
