// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Type of destination. Input can be IsolationDomain or Direct. </summary>
    public readonly partial struct NetworkTapDestinationType : IEquatable<NetworkTapDestinationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkTapDestinationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkTapDestinationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsolationDomainValue = "IsolationDomain";
        private const string DirectValue = "Direct";

        /// <summary> IsolationDomain. </summary>
        public static NetworkTapDestinationType IsolationDomain { get; } = new NetworkTapDestinationType(IsolationDomainValue);
        /// <summary> Direct. </summary>
        public static NetworkTapDestinationType Direct { get; } = new NetworkTapDestinationType(DirectValue);
        /// <summary> Determines if two <see cref="NetworkTapDestinationType"/> values are the same. </summary>
        public static bool operator ==(NetworkTapDestinationType left, NetworkTapDestinationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkTapDestinationType"/> values are not the same. </summary>
        public static bool operator !=(NetworkTapDestinationType left, NetworkTapDestinationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkTapDestinationType"/>. </summary>
        public static implicit operator NetworkTapDestinationType(string value) => new NetworkTapDestinationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkTapDestinationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkTapDestinationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
