// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Validate action that to be performed. </summary>
    public readonly partial struct NetworkFabricValidateAction : IEquatable<NetworkFabricValidateAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricValidateAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricValidateAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CablingValue = "Cabling";
        private const string ConfigurationValue = "Configuration";
        private const string ConnectivityValue = "Connectivity";

        /// <summary> Cabling. </summary>
        public static NetworkFabricValidateAction Cabling { get; } = new NetworkFabricValidateAction(CablingValue);
        /// <summary> Configuration. </summary>
        public static NetworkFabricValidateAction Configuration { get; } = new NetworkFabricValidateAction(ConfigurationValue);
        /// <summary> Connectivity. </summary>
        public static NetworkFabricValidateAction Connectivity { get; } = new NetworkFabricValidateAction(ConnectivityValue);
        /// <summary> Determines if two <see cref="NetworkFabricValidateAction"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricValidateAction left, NetworkFabricValidateAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricValidateAction"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricValidateAction left, NetworkFabricValidateAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricValidateAction"/>. </summary>
        public static implicit operator NetworkFabricValidateAction(string value) => new NetworkFabricValidateAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricValidateAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricValidateAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
