// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Type of Network Fabric SKU. </summary>
    public readonly partial struct NetworkFabricSkuType : IEquatable<NetworkFabricSkuType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricSkuType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricSkuType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleRackValue = "SingleRack";
        private const string MultiRackValue = "MultiRack";

        /// <summary> SingleRack. </summary>
        public static NetworkFabricSkuType SingleRack { get; } = new NetworkFabricSkuType(SingleRackValue);
        /// <summary> MultiRack. </summary>
        public static NetworkFabricSkuType MultiRack { get; } = new NetworkFabricSkuType(MultiRackValue);
        /// <summary> Determines if two <see cref="NetworkFabricSkuType"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricSkuType left, NetworkFabricSkuType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricSkuType"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricSkuType left, NetworkFabricSkuType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricSkuType"/>. </summary>
        public static implicit operator NetworkFabricSkuType(string value) => new NetworkFabricSkuType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricSkuType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricSkuType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
