// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct NetworkFabricProvisioningState : IEquatable<NetworkFabricProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Accepted. </summary>
        public static NetworkFabricProvisioningState Accepted { get; } = new NetworkFabricProvisioningState(AcceptedValue);
        /// <summary> Succeeded. </summary>
        public static NetworkFabricProvisioningState Succeeded { get; } = new NetworkFabricProvisioningState(SucceededValue);
        /// <summary> Updating. </summary>
        public static NetworkFabricProvisioningState Updating { get; } = new NetworkFabricProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static NetworkFabricProvisioningState Deleting { get; } = new NetworkFabricProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static NetworkFabricProvisioningState Failed { get; } = new NetworkFabricProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static NetworkFabricProvisioningState Canceled { get; } = new NetworkFabricProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="NetworkFabricProvisioningState"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricProvisioningState left, NetworkFabricProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricProvisioningState left, NetworkFabricProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricProvisioningState"/>. </summary>
        public static implicit operator NetworkFabricProvisioningState(string value) => new NetworkFabricProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
