// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Port type that needs to be matched. </summary>
    public readonly partial struct NetworkFabricPortType : IEquatable<NetworkFabricPortType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricPortType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricPortType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SourcePortValue = "SourcePort";
        private const string DestinationPortValue = "DestinationPort";

        /// <summary> SourcePort. </summary>
        public static NetworkFabricPortType SourcePort { get; } = new NetworkFabricPortType(SourcePortValue);
        /// <summary> DestinationPort. </summary>
        public static NetworkFabricPortType DestinationPort { get; } = new NetworkFabricPortType(DestinationPortValue);
        /// <summary> Determines if two <see cref="NetworkFabricPortType"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricPortType left, NetworkFabricPortType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricPortType"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricPortType left, NetworkFabricPortType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricPortType"/>. </summary>
        public static implicit operator NetworkFabricPortType(string value) => new NetworkFabricPortType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricPortType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricPortType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
