// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Network and credentials configuration already applied to terminal server. </summary>
    public partial class NetworkFabricPatchablePropertiesTerminalServerConfiguration : TerminalServerPatchableProperties
    {
        /// <summary> Initializes a new instance of <see cref="NetworkFabricPatchablePropertiesTerminalServerConfiguration"/>. </summary>
        public NetworkFabricPatchablePropertiesTerminalServerConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFabricPatchablePropertiesTerminalServerConfiguration"/>. </summary>
        /// <param name="username"> Username for the terminal server connection. </param>
        /// <param name="password"> Password for the terminal server connection. </param>
        /// <param name="serialNumber"> Serial Number of Terminal server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="primaryIPv4Prefix"> IPv4 Address Prefix. </param>
        /// <param name="primaryIPv6Prefix"> IPv6 Address Prefix. </param>
        /// <param name="secondaryIPv4Prefix"> Secondary IPv4 Address Prefix. </param>
        /// <param name="secondaryIPv6Prefix"> Secondary IPv6 Address Prefix. </param>
        internal NetworkFabricPatchablePropertiesTerminalServerConfiguration(string username, string password, string serialNumber, IDictionary<string, BinaryData> serializedAdditionalRawData, string primaryIPv4Prefix, string primaryIPv6Prefix, string secondaryIPv4Prefix, string secondaryIPv6Prefix) : base(username, password, serialNumber, serializedAdditionalRawData)
        {
            PrimaryIPv4Prefix = primaryIPv4Prefix;
            PrimaryIPv6Prefix = primaryIPv6Prefix;
            SecondaryIPv4Prefix = secondaryIPv4Prefix;
            SecondaryIPv6Prefix = secondaryIPv6Prefix;
        }

        /// <summary> IPv4 Address Prefix. </summary>
        public string PrimaryIPv4Prefix { get; set; }
        /// <summary> IPv6 Address Prefix. </summary>
        public string PrimaryIPv6Prefix { get; set; }
        /// <summary> Secondary IPv4 Address Prefix. </summary>
        public string SecondaryIPv4Prefix { get; set; }
        /// <summary> Secondary IPv6 Address Prefix. </summary>
        public string SecondaryIPv6Prefix { get; set; }
    }
}
