// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The Neighbor Group Patch definition. </summary>
    public partial class NetworkFabricNeighborGroupPatch : NetworkRackPatch
    {
        /// <summary> Initializes a new instance of <see cref="NetworkFabricNeighborGroupPatch"/>. </summary>
        public NetworkFabricNeighborGroupPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFabricNeighborGroupPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="destination"> An array of destination IPv4 Addresses or IPv6 Addresses. </param>
        internal NetworkFabricNeighborGroupPatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, string annotation, NeighborGroupDestination destination) : base(tags, serializedAdditionalRawData)
        {
            Annotation = annotation;
            Destination = destination;
        }

        /// <summary> Switch configuration description. </summary>
        public string Annotation { get; set; }
        /// <summary> An array of destination IPv4 Addresses or IPv6 Addresses. </summary>
        public NeighborGroupDestination Destination { get; set; }
    }
}
