// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The L3 Isolation Domain patch resource definition. </summary>
    public partial class NetworkFabricL3IsolationDomainPatch : NetworkRackPatch
    {
        /// <summary> Initializes a new instance of <see cref="NetworkFabricL3IsolationDomainPatch"/>. </summary>
        public NetworkFabricL3IsolationDomainPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFabricL3IsolationDomainPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="redistributeConnectedSubnets"> Advertise Connected Subnets. Ex: "True" | "False". </param>
        /// <param name="redistributeStaticRoutes"> Advertise Static Routes. Ex: "True" | "False". </param>
        /// <param name="aggregateRouteConfiguration"> Aggregate route configurations. </param>
        /// <param name="connectedSubnetRoutePolicy"> Connected Subnet RoutePolicy. </param>
        internal NetworkFabricL3IsolationDomainPatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, string annotation, RedistributeConnectedSubnet? redistributeConnectedSubnets, RedistributeStaticRoute? redistributeStaticRoutes, AggregateRouteConfiguration aggregateRouteConfiguration, ConnectedSubnetRoutePolicy connectedSubnetRoutePolicy) : base(tags, serializedAdditionalRawData)
        {
            Annotation = annotation;
            RedistributeConnectedSubnets = redistributeConnectedSubnets;
            RedistributeStaticRoutes = redistributeStaticRoutes;
            AggregateRouteConfiguration = aggregateRouteConfiguration;
            ConnectedSubnetRoutePolicy = connectedSubnetRoutePolicy;
        }

        /// <summary> Switch configuration description. </summary>
        public string Annotation { get; set; }
        /// <summary> Advertise Connected Subnets. Ex: "True" | "False". </summary>
        public RedistributeConnectedSubnet? RedistributeConnectedSubnets { get; set; }
        /// <summary> Advertise Static Routes. Ex: "True" | "False". </summary>
        public RedistributeStaticRoute? RedistributeStaticRoutes { get; set; }
        /// <summary> Aggregate route configurations. </summary>
        public AggregateRouteConfiguration AggregateRouteConfiguration { get; set; }
        /// <summary> Connected Subnet RoutePolicy. </summary>
        public ConnectedSubnetRoutePolicy ConnectedSubnetRoutePolicy { get; set; }
    }
}
