// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    public partial class NetworkFabricL3IsolationDomainPatch : IUtf8JsonSerializable, IJsonModel<NetworkFabricL3IsolationDomainPatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NetworkFabricL3IsolationDomainPatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NetworkFabricL3IsolationDomainPatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkFabricL3IsolationDomainPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetworkFabricL3IsolationDomainPatch)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Annotation))
            {
                writer.WritePropertyName("annotation"u8);
                writer.WriteStringValue(Annotation);
            }
            if (Optional.IsDefined(RedistributeConnectedSubnets))
            {
                writer.WritePropertyName("redistributeConnectedSubnets"u8);
                writer.WriteStringValue(RedistributeConnectedSubnets.Value.ToString());
            }
            if (Optional.IsDefined(RedistributeStaticRoutes))
            {
                writer.WritePropertyName("redistributeStaticRoutes"u8);
                writer.WriteStringValue(RedistributeStaticRoutes.Value.ToString());
            }
            if (Optional.IsDefined(AggregateRouteConfiguration))
            {
                writer.WritePropertyName("aggregateRouteConfiguration"u8);
                writer.WriteObjectValue(AggregateRouteConfiguration, options);
            }
            if (Optional.IsDefined(ConnectedSubnetRoutePolicy))
            {
                writer.WritePropertyName("connectedSubnetRoutePolicy"u8);
                writer.WriteObjectValue(ConnectedSubnetRoutePolicy, options);
            }
            writer.WriteEndObject();
        }

        NetworkFabricL3IsolationDomainPatch IJsonModel<NetworkFabricL3IsolationDomainPatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkFabricL3IsolationDomainPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetworkFabricL3IsolationDomainPatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNetworkFabricL3IsolationDomainPatch(document.RootElement, options);
        }

        internal static NetworkFabricL3IsolationDomainPatch DeserializeNetworkFabricL3IsolationDomainPatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            string annotation = default;
            RedistributeConnectedSubnet? redistributeConnectedSubnets = default;
            RedistributeStaticRoute? redistributeStaticRoutes = default;
            AggregateRouteConfiguration aggregateRouteConfiguration = default;
            ConnectedSubnetRoutePolicy connectedSubnetRoutePolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("annotation"u8))
                        {
                            annotation = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("redistributeConnectedSubnets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            redistributeConnectedSubnets = new RedistributeConnectedSubnet(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("redistributeStaticRoutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            redistributeStaticRoutes = new RedistributeStaticRoute(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("aggregateRouteConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            aggregateRouteConfiguration = AggregateRouteConfiguration.DeserializeAggregateRouteConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("connectedSubnetRoutePolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            connectedSubnetRoutePolicy = ConnectedSubnetRoutePolicy.DeserializeConnectedSubnetRoutePolicy(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NetworkFabricL3IsolationDomainPatch(
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData,
                annotation,
                redistributeConnectedSubnets,
                redistributeStaticRoutes,
                aggregateRouteConfiguration,
                connectedSubnetRoutePolicy);
        }

        BinaryData IPersistableModel<NetworkFabricL3IsolationDomainPatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkFabricL3IsolationDomainPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NetworkFabricL3IsolationDomainPatch)} does not support writing '{options.Format}' format.");
            }
        }

        NetworkFabricL3IsolationDomainPatch IPersistableModel<NetworkFabricL3IsolationDomainPatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkFabricL3IsolationDomainPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNetworkFabricL3IsolationDomainPatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NetworkFabricL3IsolationDomainPatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NetworkFabricL3IsolationDomainPatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
