// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The IP Extended Communities patch resource definition. </summary>
    public partial class NetworkFabricIPExtendedCommunityPatch : NetworkRackPatch
    {
        /// <summary> Initializes a new instance of <see cref="NetworkFabricIPExtendedCommunityPatch"/>. </summary>
        public NetworkFabricIPExtendedCommunityPatch()
        {
            IPExtendedCommunityRules = new ChangeTrackingList<IPExtendedCommunityRule>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFabricIPExtendedCommunityPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="ipExtendedCommunityRules"> List of IP Extended Community Rules. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        internal NetworkFabricIPExtendedCommunityPatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<IPExtendedCommunityRule> ipExtendedCommunityRules, string annotation) : base(tags, serializedAdditionalRawData)
        {
            IPExtendedCommunityRules = ipExtendedCommunityRules;
            Annotation = annotation;
        }

        /// <summary> List of IP Extended Community Rules. </summary>
        public IList<IPExtendedCommunityRule> IPExtendedCommunityRules { get; }
        /// <summary> Switch configuration description. </summary>
        public string Annotation { get; set; }
    }
}
