// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The IP Community patch resource definition. </summary>
    public partial class NetworkFabricIPCommunityPatch : NetworkRackPatch
    {
        /// <summary> Initializes a new instance of <see cref="NetworkFabricIPCommunityPatch"/>. </summary>
        public NetworkFabricIPCommunityPatch()
        {
            IPCommunityRules = new ChangeTrackingList<IPCommunityRule>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFabricIPCommunityPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="ipCommunityRules"> List of IP Community Rules. </param>
        internal NetworkFabricIPCommunityPatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<IPCommunityRule> ipCommunityRules) : base(tags, serializedAdditionalRawData)
        {
            IPCommunityRules = ipCommunityRules;
        }

        /// <summary> List of IP Community Rules. </summary>
        public IList<IPCommunityRule> IPCommunityRules { get; }
    }
}
