// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Network Fabric Controller SKU. </summary>
    public readonly partial struct NetworkFabricControllerSKU : IEquatable<NetworkFabricControllerSKU>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricControllerSKU"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricControllerSKU(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string HighPerformanceValue = "HighPerformance";

        /// <summary> Basic. </summary>
        public static NetworkFabricControllerSKU Basic { get; } = new NetworkFabricControllerSKU(BasicValue);
        /// <summary> Standard. </summary>
        public static NetworkFabricControllerSKU Standard { get; } = new NetworkFabricControllerSKU(StandardValue);
        /// <summary> HighPerformance. </summary>
        public static NetworkFabricControllerSKU HighPerformance { get; } = new NetworkFabricControllerSKU(HighPerformanceValue);
        /// <summary> Determines if two <see cref="NetworkFabricControllerSKU"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricControllerSKU left, NetworkFabricControllerSKU right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricControllerSKU"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricControllerSKU left, NetworkFabricControllerSKU right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricControllerSKU"/>. </summary>
        public static implicit operator NetworkFabricControllerSKU(string value) => new NetworkFabricControllerSKU(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricControllerSKU other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricControllerSKU other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
