// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Input method to configure Access Control List. </summary>
    public readonly partial struct NetworkFabricConfigurationType : IEquatable<NetworkFabricConfigurationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricConfigurationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricConfigurationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FileValue = "File";
        private const string InlineValue = "Inline";

        /// <summary> File. </summary>
        public static NetworkFabricConfigurationType File { get; } = new NetworkFabricConfigurationType(FileValue);
        /// <summary> Inline. </summary>
        public static NetworkFabricConfigurationType Inline { get; } = new NetworkFabricConfigurationType(InlineValue);
        /// <summary> Determines if two <see cref="NetworkFabricConfigurationType"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricConfigurationType left, NetworkFabricConfigurationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricConfigurationType"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricConfigurationType left, NetworkFabricConfigurationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricConfigurationType"/>. </summary>
        public static implicit operator NetworkFabricConfigurationType(string value) => new NetworkFabricConfigurationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricConfigurationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricConfigurationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
