// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Configuration state for the resource. </summary>
    public readonly partial struct NetworkFabricConfigurationState : IEquatable<NetworkFabricConfigurationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricConfigurationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricConfigurationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string RejectedValue = "Rejected";
        private const string AcceptedValue = "Accepted";
        private const string ProvisionedValue = "Provisioned";
        private const string ErrorProvisioningValue = "ErrorProvisioning";
        private const string DeprovisioningValue = "Deprovisioning";
        private const string DeprovisionedValue = "Deprovisioned";
        private const string ErrorDeprovisioningValue = "ErrorDeprovisioning";
        private const string DeferredControlValue = "DeferredControl";

        /// <summary> Succeeded. </summary>
        public static NetworkFabricConfigurationState Succeeded { get; } = new NetworkFabricConfigurationState(SucceededValue);
        /// <summary> Failed. </summary>
        public static NetworkFabricConfigurationState Failed { get; } = new NetworkFabricConfigurationState(FailedValue);
        /// <summary> Rejected. </summary>
        public static NetworkFabricConfigurationState Rejected { get; } = new NetworkFabricConfigurationState(RejectedValue);
        /// <summary> Accepted. </summary>
        public static NetworkFabricConfigurationState Accepted { get; } = new NetworkFabricConfigurationState(AcceptedValue);
        /// <summary> Provisioned. </summary>
        public static NetworkFabricConfigurationState Provisioned { get; } = new NetworkFabricConfigurationState(ProvisionedValue);
        /// <summary> ErrorProvisioning. </summary>
        public static NetworkFabricConfigurationState ErrorProvisioning { get; } = new NetworkFabricConfigurationState(ErrorProvisioningValue);
        /// <summary> Deprovisioning. </summary>
        public static NetworkFabricConfigurationState Deprovisioning { get; } = new NetworkFabricConfigurationState(DeprovisioningValue);
        /// <summary> Deprovisioned. </summary>
        public static NetworkFabricConfigurationState Deprovisioned { get; } = new NetworkFabricConfigurationState(DeprovisionedValue);
        /// <summary> ErrorDeprovisioning. </summary>
        public static NetworkFabricConfigurationState ErrorDeprovisioning { get; } = new NetworkFabricConfigurationState(ErrorDeprovisioningValue);
        /// <summary> DeferredControl. </summary>
        public static NetworkFabricConfigurationState DeferredControl { get; } = new NetworkFabricConfigurationState(DeferredControlValue);
        /// <summary> Determines if two <see cref="NetworkFabricConfigurationState"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricConfigurationState left, NetworkFabricConfigurationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricConfigurationState"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricConfigurationState left, NetworkFabricConfigurationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricConfigurationState"/>. </summary>
        public static implicit operator NetworkFabricConfigurationState(string value) => new NetworkFabricConfigurationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricConfigurationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricConfigurationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
