// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> State defined to represent administrative actions or post actions on a particular resource. </summary>
    public readonly partial struct NetworkFabricAdministrativeState : IEquatable<NetworkFabricAdministrativeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFabricAdministrativeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFabricAdministrativeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string MatValue = "MAT";
        private const string RmaValue = "RMA";

        /// <summary> Enabled. </summary>
        public static NetworkFabricAdministrativeState Enabled { get; } = new NetworkFabricAdministrativeState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static NetworkFabricAdministrativeState Disabled { get; } = new NetworkFabricAdministrativeState(DisabledValue);
        /// <summary> MAT. </summary>
        public static NetworkFabricAdministrativeState Mat { get; } = new NetworkFabricAdministrativeState(MatValue);
        /// <summary> RMA. </summary>
        public static NetworkFabricAdministrativeState Rma { get; } = new NetworkFabricAdministrativeState(RmaValue);
        /// <summary> Determines if two <see cref="NetworkFabricAdministrativeState"/> values are the same. </summary>
        public static bool operator ==(NetworkFabricAdministrativeState left, NetworkFabricAdministrativeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFabricAdministrativeState"/> values are not the same. </summary>
        public static bool operator !=(NetworkFabricAdministrativeState left, NetworkFabricAdministrativeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFabricAdministrativeState"/>. </summary>
        public static implicit operator NetworkFabricAdministrativeState(string value) => new NetworkFabricAdministrativeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFabricAdministrativeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFabricAdministrativeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
