// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Available roles for the network device. </summary>
    public readonly partial struct NetworkDeviceRoleName : IEquatable<NetworkDeviceRoleName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkDeviceRoleName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkDeviceRoleName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CEValue = "CE";
        private const string ToRValue = "ToR";
        private const string NpbValue = "NPB";
        private const string TSValue = "TS";
        private const string ManagementValue = "Management";

        /// <summary> CE. </summary>
        public static NetworkDeviceRoleName CE { get; } = new NetworkDeviceRoleName(CEValue);
        /// <summary> ToR. </summary>
        public static NetworkDeviceRoleName ToR { get; } = new NetworkDeviceRoleName(ToRValue);
        /// <summary> NPB. </summary>
        public static NetworkDeviceRoleName Npb { get; } = new NetworkDeviceRoleName(NpbValue);
        /// <summary> TS. </summary>
        public static NetworkDeviceRoleName TS { get; } = new NetworkDeviceRoleName(TSValue);
        /// <summary> Management. </summary>
        public static NetworkDeviceRoleName Management { get; } = new NetworkDeviceRoleName(ManagementValue);
        /// <summary> Determines if two <see cref="NetworkDeviceRoleName"/> values are the same. </summary>
        public static bool operator ==(NetworkDeviceRoleName left, NetworkDeviceRoleName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkDeviceRoleName"/> values are not the same. </summary>
        public static bool operator !=(NetworkDeviceRoleName left, NetworkDeviceRoleName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkDeviceRoleName"/>. </summary>
        public static implicit operator NetworkDeviceRoleName(string value) => new NetworkDeviceRoleName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkDeviceRoleName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkDeviceRoleName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
