// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Type of reboot to be performed. Example: GracefulRebootWithZTP. </summary>
    public readonly partial struct NetworkDeviceRebootType : IEquatable<NetworkDeviceRebootType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkDeviceRebootType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkDeviceRebootType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GracefulRebootWithZtpValue = "GracefulRebootWithZTP";
        private const string GracefulRebootWithoutZtpValue = "GracefulRebootWithoutZTP";
        private const string UngracefulRebootWithZtpValue = "UngracefulRebootWithZTP";
        private const string UngracefulRebootWithoutZtpValue = "UngracefulRebootWithoutZTP";

        /// <summary> GracefulRebootWithZTP. </summary>
        public static NetworkDeviceRebootType GracefulRebootWithZtp { get; } = new NetworkDeviceRebootType(GracefulRebootWithZtpValue);
        /// <summary> GracefulRebootWithoutZTP. </summary>
        public static NetworkDeviceRebootType GracefulRebootWithoutZtp { get; } = new NetworkDeviceRebootType(GracefulRebootWithoutZtpValue);
        /// <summary> UngracefulRebootWithZTP. </summary>
        public static NetworkDeviceRebootType UngracefulRebootWithZtp { get; } = new NetworkDeviceRebootType(UngracefulRebootWithZtpValue);
        /// <summary> UngracefulRebootWithoutZTP. </summary>
        public static NetworkDeviceRebootType UngracefulRebootWithoutZtp { get; } = new NetworkDeviceRebootType(UngracefulRebootWithoutZtpValue);
        /// <summary> Determines if two <see cref="NetworkDeviceRebootType"/> values are the same. </summary>
        public static bool operator ==(NetworkDeviceRebootType left, NetworkDeviceRebootType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkDeviceRebootType"/> values are not the same. </summary>
        public static bool operator !=(NetworkDeviceRebootType left, NetworkDeviceRebootType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkDeviceRebootType"/>. </summary>
        public static implicit operator NetworkDeviceRebootType(string value) => new NetworkDeviceRebootType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkDeviceRebootType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkDeviceRebootType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
