// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The Network Device Patch Parameters defines the patch parameters of the resource. </summary>
    public partial class NetworkDevicePatch : NetworkRackPatch
    {
        /// <summary> Initializes a new instance of <see cref="NetworkDevicePatch"/>. </summary>
        public NetworkDevicePatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkDevicePatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="hostName"> The host name of the device. </param>
        /// <param name="serialNumber"> Serial number of the device. Format of serial Number - Make;Model;HardwareRevisionId;SerialNumber. </param>
        internal NetworkDevicePatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, string annotation, string hostName, string serialNumber) : base(tags, serializedAdditionalRawData)
        {
            Annotation = annotation;
            HostName = hostName;
            SerialNumber = serialNumber;
        }

        /// <summary> Switch configuration description. </summary>
        public string Annotation { get; set; }
        /// <summary> The host name of the device. </summary>
        public string HostName { get; set; }
        /// <summary> Serial number of the device. Format of serial Number - Make;Model;HardwareRevisionId;SerialNumber. </summary>
        public string SerialNumber { get; set; }
    }
}
