// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> The Interface Type. Example: Management/Data. </summary>
    public readonly partial struct NetworkDeviceInterfaceType : IEquatable<NetworkDeviceInterfaceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkDeviceInterfaceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkDeviceInterfaceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManagementValue = "Management";
        private const string DataValue = "Data";

        /// <summary> Management. </summary>
        public static NetworkDeviceInterfaceType Management { get; } = new NetworkDeviceInterfaceType(ManagementValue);
        /// <summary> Data. </summary>
        public static NetworkDeviceInterfaceType Data { get; } = new NetworkDeviceInterfaceType(DataValue);
        /// <summary> Determines if two <see cref="NetworkDeviceInterfaceType"/> values are the same. </summary>
        public static bool operator ==(NetworkDeviceInterfaceType left, NetworkDeviceInterfaceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkDeviceInterfaceType"/> values are not the same. </summary>
        public static bool operator !=(NetworkDeviceInterfaceType left, NetworkDeviceInterfaceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkDeviceInterfaceType"/>. </summary>
        public static implicit operator NetworkDeviceInterfaceType(string value) => new NetworkDeviceInterfaceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkDeviceInterfaceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkDeviceInterfaceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
